
**FIGURE CODING**

*The data used to generate these figures are confidential and are not provided. Further manipulation of data sometimes required after export.

ssc install tabout
ssc install tablecol

* Figure 1
* Title: Cash Payments
* Subtitle: Share of number of payments in each category

* Code

use "", clear

*GRAPH BY AGE AND AGE-ADJUSTED HHINCQ
* LHS - by age, 2007 & 2019 dots/bars
tablecol paymethcons3 agebin [pw=dweight] if paymeth >= 0 &  paymeth !=12  & payamt >= 0 & payamt < 9999 & year==2007, nofreq colpct
tablecol paymethcons3 agebin [pw=dweight] if paymeth >= 0 &  paymeth !=12 & payamt >= 0 & payamt < 9999 & year==2019, nofreq colpct

quietly: tabout paymethcons3 agebin [iw=dweight] if paymeth >= 0 &  paymeth !=12  & payamt >= 0 & payamt < 9999 & year==2007 using "Figure 1.xls", clab(Graph_3l_%_2007) cell(col) format(4) replace
quietly: tabout paymethcons3 agebin [iw=dweight] if paymeth >= 0 &  paymeth !=12  & payamt >= 0 & payamt < 9999 & year==2019 using "Figure 1.xls", clab(Graph_3l_%_2019) cell(col) format(4) append

* RHS - by age-adjusted income
tablecol paymethcons3 agehhincq [pw=dweight] if paymeth >= 0 &  paymeth !=12  & payamt >= 0 & payamt < 9999 & year==2007, nofreq colpct
tablecol paymethcons3 agehhincq [pw=dweight] if paymeth >= 0 &  paymeth !=12  & payamt >= 0 & payamt < 9999 & year==2019, nofreq colpct

quietly: tabout paymethcons3 agehhincq [iw=dweight] if paymeth >= 0 &  paymeth !=12  & payamt >= 0 & payamt < 9999 & year==2007 using "Figure 1.xls", clab(Graph_3r_%_2007) cell(col) format(4) append
quietly: tabout paymethcons3 agehhincq [iw=dweight] if paymeth >= 0 &  paymeth !=12  & payamt >= 0 & payamt < 9999 & year==2019 using "Figure 1.xls", clab(Graph_3r_%_2019) cell(col) format(4) append



* Figure 2
* Title: Trends in Card and Cash Payments
* Subtitle: Share of Number of payments

* See Figure 3 for Australian data.



* Figure 3
* Title: Cash Payments
* Subtitle: Share of Consumer Payments

* Code
use "", clear

* TOP: BY NUMBER CONSUMER PAYMENT METHODS
tablecol paymethcons3 year [pw=dweight] if paymeth >= 0 & payamt >= 0 & payamt < 9999, nofreq colpct
quietly: tabout paymethcons3 year [iw=dweight] if paymeth >= 0 & payamt >= 0 & payamt < 9999 using "Figure 3.xls",  clab(LHS) format(4) cell(col) replace

* BOTTM: BY VALUE CONSUMER PAYMENT METHODS(see excel file for conversion to shares )
table paymethcons3 year [pw=dweight] if paymeth >= 0 & payamt >= 0 & payamt < 9999, c(sum payamtr)
quietly: tabout paymethcons3 year [aw=dweight] if paymeth >= 0 & payamt >= 0 & payamt < 9999 using "Figure 3.xls", clab(RHS) sum c(sum payamtr) format(4) append



*Figure 4
* Title: Cash and Card Payments by Transaction Size
* Subtitle: In-person payments under $100

* Code
use "", clear

**recode in person payment channels to their respective payment channel
replace paychan =1 if year ==2019 & inlist(paychanx,1,2,3,4)
replace paychan =1 if year ==2019 & paymeth == 1
*first change paychan for 2019 to online or smartphone
replace paychan = 2 if paychan2019 == 6 & year == 2019
replace paychan = 3 if paychan2019 == 5 & year == 2019
***add offline into mail although not used for this purpose
replace paychan = 5 if paychan2019 == 7 & year == 2019

** GRAPH PAYMENTS BY TRANSACTION SIZE
 * Panel 1: 2019
tablecol payamtr paymethcons2 if paymethcons2>0 & payamtr>=0 & payamtr<=100 & year==2019 & paychan == 1  [pw=dweight], rowpct nofreq
quietly: tabout payamtr paymethcons2 if paymethcons2>0 & payamtr>=0  & payamtr<=100 & year==2019 & paychan == 1 [aw=weight] using "Figure 4.xls", replace clab(2019) format(4) cell(row)
  
 * Panel 2: 2007
tablecol payamtr paymethcons2 if paymethcons2>0 & payamtr>=0 & payamtr<=100 & year==2007 [pw=dweight], rowpct nofreq
quietly: tabout payamtr paymethcons2 if paymethcons2>0 & payamtr>=0  & payamtr<=100 & year==2007 & paychan == 1  [aw=dweight] using "Figure 4.xls", append clab(2007) format(4) cell(row)



* Figure 5
* Title: Cash Payments by Sector
* Subtitle: Share of number of payments

* Code
use "", clear

*GRAPH PAYMENT PURPOSE - these include all payment types, not just in person ones
quietly: tabout paypurpcons2  year if payamt >= 0 & payamt >= 0 & payamt < 9999 [aw=dweight] using "PaymentPurpose.xls", replace  c(median payamtr)  sum

tabout paymeth paypurpcons2 if payamt >= 0 & payamt >= 0 & payamt < 9999 & year == 2019 & paypurpcons2 >=0 [aw=dweight] using "Figure 5.xls", format(4) cell(col) append clab(2019)
tabout paymeth paypurpcons2 if payamt >= 0 & payamt >= 0 & payamt < 9999 & year == 2016 & paypurpcons2 >=0 [aw=dweight] using "Figure 5.xls", format(4) cell(col) append clab(2016)



* Figure 6
* Title: Individuals' Cash Payments
* Subtitle: Cumulative distribution

* Code
use "", clear

**recode in person payment channels to their respective payment channel
replace paychan =1 if year ==2019 & inlist(paychanx,1,2,3,4)
replace paychan =1 if year ==2019 & paymeth == 1
*first change paychan for 2019 to online or smartphone
replace paychan = 2 if paychan2019 == 6 & year == 2019
replace paychan = 3 if paychan2019 == 5 & year == 2019
***add offline into mail although not used for this purpose
replace paychan = 5 if paychan2019 == 7 & year == 2019

*generate a cashuse percentile
egen cashusenumpos=sum(paymeth==1 & paychan==1 & payamt>=0 & payamt<9999 ), by(id)
egen paymentnumpos=sum(paymeth>0 & paychan==1 & paymeth != 12 & payamt>=0 & payamt<9999 ), by(id)
gen cashusepctpos=cashusenumpos/paymentnumpos

** GRAPH CUMULATIVE DISTRIBUTION OF CASH PAYMENTS
* To calcualte cumulative distribution graph (see spreadsheet) and make it comparable over time, cut individual cash use into 1/10th percentiles. 
egen cashposbins1 = cut(cashusepctpos), at(0(0.001)1.001)

*****GRAPH CUMULATIVE DISTRIBUTION
tablecol cashposbins1 year if idtag==1 [pw=dweight], colpct nofreq
quietly: tabout cashposbins1 year if idtag==1 [iw=dweight] using "Figure 6.xls", replace format(4) c(col)



* Figure 7
* Title: Use of One Payment Method
* Subtitle: Share of respondents, in-person payments

* Code
use "", clear

**recode in person payment channels to their respective payment channel
replace paychan =1 if year ==2019 & inlist(paychanx,1,2,3,4)
replace paychan =1 if year ==2019 & paymeth == 1
*first change paychan for 2019 to online or smartphone
replace paychan = 2 if paychan2019 == 6 & year == 2019
replace paychan = 3 if paychan2019 == 5 & year == 2019
***add offline into mail although not used for this purpose
replace paychan = 5 if paychan2019 == 7 & year == 2019

*generate different number of methods used for POS
egen cashtrans = sum(paymethcons==1 & paychan==1 & payamt >= 0 & payamt <9999), by(id)
egen debittrans = sum(paymethcons==2 & paychan==1 & payamt >= 0 & payamt <9999), by(id)
egen credittrans = sum(paymethcons==3 & paychan==1 & payamt >= 0 & payamt <9999), by(id)
egen bpaynettrans = sum(paymethcons==4 & paychan==1 & payamt >= 0 & payamt <9999), by(id)
*recode gift/prepaid to othertrans
replace paymethcons = 5 if paymethcons==11
egen othertrans = sum(paymethcons==5 & paychan==1 & payamt >= 0 & payamt <9999), by(id)


replace cashtrans=1 if cashtrans>0
replace debittrans=1 if debittrans>0
replace credittrans=1 if credittrans>0
replace bpaynettrans=1 if bpaynettrans>0
replace othertrans=1 if othertrans>0


egen totaltrans = rowtotal(cashtrans - othertrans)

tabout totaltrans year if idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", replace format(4) c(col) 

**by different methods
tabout totaltrans cashtrans if year ==2019 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2019cash)
tabout totaltrans debittrans if year ==2019 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2019debit)
tabout totaltrans credittrans if year ==2019 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2019credit)
tabout totaltrans bpaynettrans if year ==2019 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2019bpaynet)
tabout totaltrans othertrans if year ==2019 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2019other)

tabout totaltrans cashtrans if year ==2016 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2016cash)
tabout totaltrans debittrans if year ==2016 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2016debit)
tabout totaltrans credittrans if year ==2016 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2016credit)
tabout totaltrans bpaynettrans if year ==2016 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2016bpaynet)
tabout totaltrans othertrans if year ==2016 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2016other)

tabout totaltrans cashtrans if year ==2013 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2013cash)
tabout totaltrans debittrans if year ==2013 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2013debit)
tabout totaltrans credittrans if year ==2013 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2013credit)
tabout totaltrans bpaynettrans if year ==2013 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2013bpaynet)
tabout totaltrans othertrans if year ==2013 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2013other)

tabout totaltrans cashtrans if year ==2010 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2010cash)
tabout totaltrans debittrans if year ==2010 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2010debit)
tabout totaltrans credittrans if year ==2010 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2010credit)
tabout totaltrans bpaynettrans if year ==2010 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2010bpaynet)
tabout totaltrans othertrans if year ==2010 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2010other)

tabout totaltrans cashtrans if year ==2007 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2007cash)
tabout totaltrans debittrans if year ==2007 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2007debit)
tabout totaltrans credittrans if year ==2007 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2007credit)
tabout totaltrans bpaynettrans if year ==2007 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2007bpaynet)
tabout totaltrans othertrans if year ==2007 & idtag == 1 & totaltrans >0 [aw=dweight] using "Figure 7.xls", append format(4) c(freq) clab(2007other)



* Figure 8
* Title: Why Use Cash
* Subtitle: Most Important Reason, 2019

* Code
use "", clear

**generate a cash use percentage
**Why use cash by cash use
**generate a cashuse percentile
replace payinper = 1 if paymeth == 1
egen cashusenumpos=sum(paymeth==1 & payinper==1 & payamt >= 0 & payamt <9999), by(casenumber)
egen paymentnumpos=sum(paymeth>0 & payinper==1 & paymeth != 11 & payamt >= 0 & payamt <9999), by(casenumber)
gen cashusepctpos=cashusenumpos/paymentnumpos

egen poscashbins=cut(cashusepctpos), at(0,0.20,0.40,0.60,0.80,1.01)

tabout q8 poscashbins if idtag == 1 & q8 >= 0 [iw=weight] using "Figure 8.xls", replace format(4) c(col)



* Figure 9
* Title: Wallet Cash Holdings
* Subtitle: Share of respondents in each category

* Code
use "", clear

quietly: tabout banknotes year if idtag == 1  & banknotes >= 0  [aw=dweight] using "Figure 9.xls", replace format(4) cell(col)


* Figure 10
* Title: Why Hold Cash?
* Subtitle: Most important reason cited, 2019

* Code
use "", clear

*q14 inside wallet
tabout q14 idtag if idtag == 1 & q14 >= 0 [iw=weight] using "Figure 10.xls", replace format(4) c(col)

*outside wallet q18
tabout q18 idtag if idtag == 1 & q18 >= 0 [iw=weight] using "Figure 10.xls", append format(4) c(col)


* Figure 11
* Title: ATM Cash Withdrawals
* Subtitle: Monthly, seasonally adjusted

* Uses RPS data.



* Figure 12
* Title: Perceptions of Access to Cash
* Subtitle: Share of respondents in each category, 2019

* Code
use "", clear

tabout q9a  if idtag == 1 [aw=weight] using "Figure 12.xls", format(4) cell(col) replace
tabout q9b  if idtag == 1 [aw=weight] using "Figure 12.xls", format(4) cell(col) append



* Figure 13
* Title: Effects of No Cash Services by Age
* Subtitle: Share of respondents in each category, 2019

* Code
use "", clear

***GRAPH - EFFECTS OF NO CASH
tabout q10 agebin  if idtag == 1 & q10 >= 0  [aw=weight] using "Figure 13.xls", format(4) cell(col) append



* Figure 14
* Title: Card Payments
* Subtitle: Change in share of number of transactions by value, 2016 to 2019

* Code
use "", clear

quietly: tabout payamtbinr2 paymethcons if year==2019 & payamt>=0 & payamt<9999 & paymeth>0 [iw=dweight] using "Figure 14.xls",  clab(2019) format(4) cell(row) replace

quietly: tabout payamtbinr2 paymethcons if year==2016 & payamt>=0 & payamt<9999 & paymeth>0 [iw=dweight] using "Figure 14.xls",  clab(2016) format(4) cell(row) append


* Figure 15
* Title: Percieved Effect of Credit Card Ownership
* Subtitle: Share of credit card owner respondents

* Code
use "", clear

tab q22 if idtag==1 & q22>0 [iw=weight]

quietly: tabout q22 if idtag==1 & q22>0 [iw=weight] using "Figure 15.xls",  clab(2019) format(4) cell(col) replace

* Code
use "", clear
tab q8h if idtag==1 & q8h>0 [iw=w1_noint]

quietly: tabout q8h if idtag==1 & q8h>0 [iw=w1_noint] using "Figure 15.xls",  clab(2016) format(4) cell(col) append


* Figure 16
* Title: Transactions by Card Type
* Subtitle: Monthly, seasonally adjusted

* Uses RPS data.




* Figure 17
* Title: Change in the Payment Mix by Age
* Subtitle: Change in share of number of payments, 2016 to 2019

* Code
use "", clear

table paymethcons agebin year if payamt>=0 & payamt<9999 & paymethcons>0 &inlist(year,2016,2019) [iw=dweight]

quietly: tabout paymethcons agebin if payamt>=0 & payamt<9999 & paymethcons>0 & inlist(year,2016) [iw=dweight] using "Figure 17.xls",  clab(2016) format(4) cell(col) replace

quietly: tabout paymethcons agebin if payamt>=0 & payamt<9999 & paymethcons>0 & inlist(year,2019) [iw=dweight] using "Figure 17.xls",  clab(2019) format(4) cell(col) append




* Figure 18
* Title: Debit Card Use by Age
* Subtitle: Share of total number of payments, 2019

* Code
use "", clear

table paymeth agebin ccown if ccown>=0 & payamt>=0 & payamt<9999 & paymeth>0 & inlist(year,2019) [iw=dweight]

quietly: tabout paymeth agebin if payamt>=0 & payamt<9999 & paymeth>0 & inlist(year,2019) [iw=dweight] using "Figure 18.xls",  clab(all) format(4) cell(col) replace

quietly: tabout paymeth agebin if ccown==1 & payamt>=0 & payamt<9999 & paymeth>0 & inlist(year,2019) [iw=dweight] using "Figure 18.xls",  clab(own) format(4) cell(col) append

quietly: tabout paymeth agebin if ccown==0 & payamt>=0 & payamt<9999 & paymeth>0 & inlist(year,2019) [iw=dweight] using "Figure 18.xls",  clab(not own) format(4) cell(col) append


* Figure 19
* Title: Influence on In-Person Payment Method Choice
* Subtitle: Share of most important factor

* 2019
use "", clear

tab q29 if q29>0 & idtag==1 [iw=weight]

quietly: tabout q29 if q29>0 & idtag==1 [iw=weight] using "Figure 19.xls",  clab(2019) format(4) replace

* 2016
use "", clear


tab q2a if idtag==1 & q2a>0 [iw=w1_noint]

quietly: tabout q2a if idtag==1 & q2a>0 [iw=w1_noint] using "Figure 19.xls",  clab(2016) format(4) append


* Figure 20
* Title: Contactless Card Payments
* Subtitle: Share of number of in-person payments

* Code
use "", clear

recode paychanx -5=1 if inlist(year,2013,2016) & cardact==1
recode paychanx -5=2 if inlist(year,2013,2016) & cardact==4
recode paychanx -5=3 if inlist(year,2013,2016) & inlist(cardact,2,3)
recode paychanx -5=5 if inlist(year,2013,2016) & paychan==2
recode paychanx -5=5 if inlist(year,2013,2016) & paychan==3 & !inlist(cardact,1,2,3,4)
recode paychanx -5=6 if inlist(year,2013,2016) & inlist(paychan,4,5) 
replace paychan =1 if inlist(paychanx,1,2,3,4)

tab paychanx year if inlist(paychanx,1,2,3,4) & paymeth>=0 & paymeth!=12 & payamt>=0 & payamt<9999 [aw=nweight], col nofreq
tab paychanx year if inlist(paychanx,1,2,3) & paymeth>0 & paymeth!=12 & payamt>=0 & payamt<9999 [aw=nweight], col nofreq
quietly tabout paychanx year if inlist(paychanx,1,2,3,4) & paymeth>=0 & paymeth!=12 & payamt>=0 & payamt<9999  [aw=nweight] using "Figure 20.xls", h1(share of all pos payments by year) format(2) cell(col) replace
quietly tabout paychanx year if inlist(paychanx,1,2,3,4) & inlist(paymeth,2,3,4,5) & paymeth>=0 & paymeth!=12 & payamt>=0 & payamt<9999  [aw=nweight] using "Figure 20.xls", h1(share of all pos card payments by year) format(2) cell(col) append


* Figure 21
* Title: In-person Payments
* Subtitle: Change in share of number of payments by value, 2016 to 2019

* Code
use "", clear

**recode in person payment channels to their respective payment channel
replace paychan =1 if year ==2019 & inlist(paychanx,1,2,3,4)
replace paychan =1 if year ==2019 & paymeth == 1
*first change paychan for 2019 to online or smartphone
replace paychan = 2 if paychan2019 == 6 & year == 2019
replace paychan = 3 if paychan2019 == 5 & year == 2019
***add offline into mail although not used for this purpose
replace paychan = 5 if paychan2019 == 7 & year == 2019


table year payamtbinr2 paychanx if inlist(paychanx,1,2,3,4) & payamt>=0 & payamt<9999 & paymeth>0 [iw=dweight]

quietly: tabout paychanx payamtbinr2 if inlist(paychanx,1,2,3,4) & payamt>=0 & payamt<9999 & paymeth>0 & year==2019 [iw=dweight] using "Figure 21.xls",  clab(2019) format(4) replace

quietly: tabout paychanx payamtbinr2 if inlist(paychanx,1,2,3,4) & payamt>=0 & payamt<9999 & paymeth>0 & year==2016 [iw=dweight] using "Figure 21.xls",  clab(2016) format(4) append

quietly: tabout paymethcons2 payamtbinr2 if paychan==1 & paymeth>0 & payamt>=0 & payamt<9999 & year==2019 [iw=dweight] using "Figure 21.xls", c(col) format (4) append

quietly: tabout paymethcons2 payamtbinr2 if paychan==1 & paymeth>0 & payamt>=0 & payamt<9999 & year==2016 [iw=dweight] using "Figure 21.xls", c(col) format(4) append


* Figure 22
* Title: Mobile Device Use by Age
* Subtitle: 2019

* Code
use "", clear

*First, find users of tap device payments (same as March 2020 Bulletin)
gen tapdev=0
replace tapdev=1 if paychan==2
by casenumber, sort: egen tapdevdummy=max(tapdev)
tab paychan agebin if  tapdevdummy==1 & inlist(paychan,1,2,3,4) & paymeth>0 & paymeth!=11 & payamt>=0 & payamt<9999 [iw=weight], col nofreq
tab tapdevdummy agebin if idtag==1 [iw=weight], col nofreq


quietly: tabout tapdevdummy agebin if idtag==1 [iw=weight] using "Figure 22.xls",  clab(user) format(4) cell(col) replace

*Then show in-person payment channel split for those who used this method.

quietly: tabout paychan agebin if  tapdevdummy==1 & inlist(paychan,1,2,3,4) & paymeth>0 & paymeth!=11 & payamt>=0 & payamt<9999 [iw=weight] using "Figure 22.xls",  clab(usebyuser) format(4) cell(col) append



* Figure 23
* Title: Use and Awareness of Mobile Wallets by Age
* Subtitle: Share of respondents, 2019

* Code
use "", clear

tab q26_f agebin if idtag==1 [iw=weight]
quietly: tabout q26_f agebin if idtag==1 [iw=weight] using "Figure 23.xls",  clab(mobile) format(4) cell(col) replace

assert q35>0 if q36>0
tab q36 agebin if idtag==1 [iw=weight]
quietly: tabout q36 agebin if idtag==1 [iw=weight] using "Figure 23.xls",  clab(mobile) format(4) cell(col) append


* Figure 24
* Title: Response to Payment Surcharge
* Subtitle: Share of respondents, 2019

* Code
use "", clear

tab q25 agebin if q25>0 & idtag==1 [iw=weight]

quietly: tabout q25 agebin if q25>0 & idtag==1 [iw=weight] using "Figure 24.xls",  clab(2019) format(4) replace


* Figure 25
* Title: Online Payments by Age
* Subtitle: 2019

* Code
use "", clear

set more off

replace paychan =1 if year ==2019 & inlist(paychanx,1,2,3,4)
replace paychan =1 if year ==2019 & paymeth == 1
*first change paychan for 2019 to online or smartphone
replace paychan = 2 if paychan2019 == 6 & year == 2019
replace paychan = 3 if paychan2019 == 5 & year == 2019
***add offline into mail although not used for this purpose
replace paychan = 5 if paychan2019 == 7 & year == 2019

* create dummy for whether respondent made at least one online payment
egen onlinepay=sum(inlist(paychan,2,3)),by(id)
replace onlinepay=1 if onlinepay>0

**get share of online payment users
tablecol onlinepay year if idtag == 1 [aw=dweight], colpct nofreq

tablecol agebin onlinepay if idtag == 1 & year == 2019 [aw=dweight], rowpct nofreq
tablecol agebin paychan if onlinepay == 1 & year == 2019 [aw=dweight], rowpct nofreq

quietly: tabout agebin onlinepay [iw=dweight] if idtag == 1 & year == 2019  using "Figure 25.xls",  format(4) cell(row) replace
quietly: tabout agebin paychan [iw=dweight] if  onlinepay == 1 & year == 2019  using "Figure 25.xls",  format(4) cell(row) append



* Figure 26
* Title: Use of Stored Cards for Online Payments
* Subtitle: Share of respondents, 2019

* Code
use "", clear

assert q43>0 if q44>0
tab q44 agebin if idtag==1  [iw=weight]

quietly: tabout q44 agebin if idtag==1 & q44!=-5 [iw=weight] using "Figure 26.xls",  clab(stored) format(4) cell(col) replace



* Figure 27
* Title: Automated Payments
* Subtitle: Share of total spending

* Code
use "", clear

quietly: tabout year paypurpcons  [aw=nweight] if  inlist(year,2013,2016,2019) & paymeth>=0 & payamt>=0 & payamt<9999  using "Figure 27.xls",  clab(Table_8_nonautonum) format(4) cell(freq) replace
quietly: tabout year paypurpcons  [aw=nweight] if  inlist(year,2013,2016,2019) & paymeth>=0 & payamt>=0 & payamt<9999  using "Figure 27.xls",  clab(Table_8_nonautoval) format(4) sum c(sum payamt) append

use "", clear

quietly: tabout year autopurp   if inweek==1 & autopurp>0 [aw=nweight] using "Figure 27.xls",  clab(Table_8_autonum) format(4) cell(freq) append 
quietly: tabout year autopurp   if inweek==1 & autopurp>0 [aw=nweight] using "Figure 27.xls",  clab(Table_8_autoval) format(4) sum c(sum autoamt) append 


* Figure 28
* Title: Personal Cheque Payments by Age
* Subtitle: Share of number of all payments

* Code
use "", clear

table paymeth agebin year if payamt>=0 & payamt<9999 & paymeth>0 [iw=dweight]

quietly: tabout paymeth agebin if year==2019 & payamt>=0 & payamt<9999 & paymeth>0 [iw=dweight] using "Figure 28.xls", clab(2019) format(4) cell(col) replace

quietly: tabout paymeth agebin if year==2007 & payamt>=0 & payamt<9999 & paymeth>0 [iw=dweight] using "Figure 28.xls", clab(2007) format(4) cell(col) append


* Figure 29
* Title: Personal Cheque Use in Last Year by Age
* Subtitle: Share of respondents, 2019

* Code
use "", clear

tab q5 agebin if idtag==1 & q5>=0 [iw=weight]

quietly: tabout q5 agebin if idtag==1 & q5>=0 [iw=weight] using "Figure 29.xls", format(4) cell(col) replace




* Figure 30
* Title: Reasons for Personal Cheque Use
* Subtitle: Share of users, 2019

* Code
use "", clear

tab q6_a if q5>0 & idtag==1 [iw=weight]
tab q6_b if q5>0 & idtag==1 [iw=weight]
tab q6_c if q5>0 & idtag==1 [iw=weight]
tab q6_d if q5>0 & idtag==1 [iw=weight]

quietly: tabout q6_a [iw=weight] if q5>0 & idtag==1 using "Figure 30.xls",  h1(I prefer to use personal cheques for some payments) format(4) replace
quietly: tabout q6_b [iw=weight] if q5>0 & idtag==1 using "Figure 30.xls",  h1(I don't have access to another method to make these payments, such as internet banking) format(4) append
quietly: tabout q6_c [iw=weight] if q5>0 & idtag==1 using "Figure 30.xls",  h1(The receiver would only accept cheques as payment) format(4) append
quietly: tabout q6_d [iw=weight] if q5>0 & idtag==1 using "Figure 30.xls",  h1(Other) format(4) append



* Figure 31
* Title: Alternative Payment Methods
* Subtitle: Share of all respondents, 2019

* Code
use "", clear

*****************Heard and used new payment methods
quietly: tabout q26_a if idtag == 1 & q26_a>=0 [aw=weight] using "Figure 31.xls",clab(HeardMethods) cells(col) append  format(4)
quietly: tabout q26_b if idtag == 1 & q26_b>=0 [aw=weight] using "Figure 31.xls",clab(HeardMethods) cells(col) append  format(4)
quietly: tabout q26_c if idtag == 1 & q26_c>=0 [aw=weight] using "Figure 31.xls",clab(HeardMethods) cells(col) append  format(4)
quietly: tabout q26_d if idtag == 1 & q26_d>=0 [aw=weight] using "Figure 31.xls",clab(HeardMethods) cells(col) append  format(4)
quietly: tabout q26_e if idtag == 1 & q26_e>=0 [aw=weight] using "Figure 31.xls",clab(HeardMethods) cells(col) append  format(4)
quietly: tabout q26_f if idtag == 1 & q26_f>=0 [aw=weight] using "Figure 31.xls",clab(HeardMethods) cells(col) append  format(4)
quietly: tabout q26_g if idtag == 1 & q26_g>=0 [aw=weight] using "Figure 31.xls",clab(HeardMethods) cells(col) append  format(4)
quietly: tabout q26_h if idtag == 1 & q26_h>=0 [aw=weight] using "Figure 31.xls",clab(HeardMethods) cells(col) append  format(4)
***Used Methods?
quietly: tabout q26a_a if idtag == 1 & q26_a>=0 [aw=weight] using "Figure 31.xls",clab(UsedMethods) cells(col) append  format(4)
quietly: tabout q26a_b if idtag == 1 & q26_b>=0 [aw=weight] using "Figure 31.xls",clab(UsedMethods) cells(col) append  format(4)
quietly: tabout q26a_c if idtag == 1 & q26_c>=0 [aw=weight] using "Figure 31.xls",clab(UsedMethods) cells(col) append  format(4)
quietly: tabout q26a_d if idtag == 1 & q26_d>=0 [aw=weight] using "Figure 31.xls",clab(UsedMethods) cells(col) append  format(4)
quietly: tabout q26a_e if idtag == 1 & q26_e>=0 [aw=weight] using "Figure 31.xls",clab(UsedMethods) cells(col) append  format(4)
quietly: tabout q26a_f if idtag == 1 & q26_f>=0 [aw=weight] using "Figure 31.xls",clab(UsedMethods) cells(col) append  format(4)
quietly: tabout q26a_g if idtag == 1 & q26_g>=0 [aw=weight] using "Figure 31.xls",clab(UsedMethods) cells(col) append  format(4)
quietly: tabout q26a_h if idtag == 1 & q26_h>=0 [aw=weight] using "Figure 31.xls",clab(UsedMethods) cells(col) append  format(4)




* Figure 32
* Title: BNPL Use by Age
* Subtitle: Share of respondents in each age category who used bnpl in the past 12 months

* Code
use "", clear

tablecol q37 agebin if idtag == 1 [iw=weight], colpct nofreq
quietly: tabout q37 agebin  if idtag == 1 [aw=weight] using "Figure 32.xls",  format(4)  cell(col) replace



* Figure 33
* Title: Frequency of BNPL Use
* Subtitle: Among those using BNPL in last 12 months

* Code
use "", clear

tab q38 if idtag==1 & q38>0 [iw=weight]
quietly: tabout q38 if idtag==1 & q38>0 [iw=weight] using "Figure 33.xls",  format(4) cell(col) replace


* Figure 34
* Title: Reasons for Not Using Alternative Payment Methods
* Subtitle: Share of respondents aware of method but not using it in the last 12 months

* Code
use "", clear

*Reasons condensed down from list of responses; 'other reason' not shown. Categories are (27x_y, where y is the letter shown below):
* a - what i have meets my needs
* b c don't have needed tools/don't know how to use
* d e concerned aout privacy/security
* f - worried about spending control
* g - sellers don't accept

tabout q27a_a if idtag==1 & q27a_a>=0 [iw=weight] using "Figure 34.xls", format(4) replace

tabout q27a_b q27a_c if idtag==1 & q27a_b>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27a_d q27a_e if idtag==1 & q27a_d>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27a_f if idtag==1 & q27a_f>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27a_g if idtag==1 & q27a_g>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27f_a if idtag==1 & q27f_a>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27f_b q27f_c if idtag==1 & q27f_b>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27f_d q27f_e if idtag==1 & q27f_d>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27f_f if idtag==1 & q27f_f>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27f_g if idtag==1 & q27f_g>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27h_a if idtag==1 & q27h_a>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27h_b q27h_c if idtag==1 & q27h_b>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27h_d q27h_e if idtag==1 & q27h_d>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27h_f if idtag==1 & q27h_f>=0 [iw=weight] using "Figure 34.xls", format(4) append

tabout q27h_g if idtag==1 & q27h_g>=0 [iw=weight] using "Figure 34.xls", format(4) append



* Figure 35
* Title: Person-to-person Payments by Channel
* Subtitle: Share of number of person-to-person payments

* 2019
use "", clear
**create a dummy for if a person made a transfer
egen transfers=sum(paypurp==17),by(casenumber)
tab transfers if idtag == 1
tab transfers lifestage if idtag == 1
**check as a share of total spending
tab paypurp [iw=weight] if payment==1 & paypurp>0 & payamt>=0 & payamt<9999
table paypurp [iw=weight] if payment==1 & paypurp>0 & payamt>=0 & payamt<9999, c(sum payamt) row
**check median value 
table paypurp paychan [pw=weight] if payment==1 & paypurp>0 & payamt>=0 & payamt<9999, c(median payamt) row
tablecol paychan agebin [pw=weight] if payment==1 & paychan>0 & paypurp==17 & payamt>=0 & payamt<9999, nofreq colpct row

tablecol paychan payment [pw=weight] if payment==1 & paychan>0 & paypurp==17 & payamt>=0 & payamt<9999, nofreq colpct row
tablecol paymeth payment [pw=weight] if payment==1 & paymeth>0 & paypurp==17 & payamt>=0 & payamt<9999, nofreq colpct row

quietly: tabout paychan payment [iw=weight] if payment==1 & paychan>0 & paypurp==17 & payamt>=0 & payamt<9999 using "Figure 35.xls",  clab(2019) format(4) cell(col) replace

* 2016
use "", clear
**create a dummy for if a person made a transfer
egen transfers=sum(paypurp==17),by(id)
tab transfers if idtag == 1
**check as a share of total spending
tab paypurp [iw=w1_noint] if payment==1 & paypurp>0 & payamt>=0 & payamt<9999
table paypurp [iw=w1_noint] if payment==1 & paypurp>0 & payamt>=0 & payamt<9999, c(sum payamt) row
table paypurp paychan [pw=w1_noint] if payment==1 & paypurp>0 & payamt>=0 & payamt<9999, c(median payamt) row

tablecol paychan agebin [pw=w1_noint] if payment==1 & paychan>0 & paypurp==17 & payamt>=0 & payamt<9999, nofreq colpct row

tablecol paychan payment [pw=w1_noint] if payment==1 & paychan>0 & paypurp==17 & payamt>=0 & payamt<9999, nofreq colpct row
tablecol paymethx payment [pw=w1_noint] if payment==1 & paymethx>0 & paypurp==17 & payamt>=0 & payamt<9999, nofreq colpct row

quietly: tabout paychan payment [iw=w1_noint] if payment==1 & paychan>0 & paypurp==17 & payamt>=0 & payamt<9999 using "Figure 35.xls",  clab(2016) format(4) cell(col) append

*2013
use "", clear

**create a dummy for if a person made a transfer
egen transfers=sum(paypurp==15),by(id)
tab transfers if idtag == 1
**check as a share of total spending
tab paypurp [iw=weight1] if payment==1 & paypurp>0 & payamt>=0 & payamt<9999
table paypurp [iw=weight1] if payment==1 & paypurp>0 & payamt>=0 & payamt<9999, c(sum payamt) row
table paypurp paychan [pw=weight1] if payment==1 & paypurp>0 & payamt>=0 & payamt<9999, c(median payamt) row


tablecol paychan payment [pw=weight1] if payment==1 & paychan>0 & paypurp==15 & payamt>=0 & payamt<9999, nofreq colpct row
tablecol paymethx payment [pw=weight1] if payment==1 & paymethx>0 & paypurp==15 & payamt>=0 & payamt<9999, nofreq colpct row

quietly: tabout paychan payment [iw=weight1] if payment==1 & paychan>0 & paypurp==15 & payamt>=0 & payamt<9999 using "Figure 35.xls",  clab(2013) format(4) cell(col) append


